﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

namespace hiveAdiz
{
    public class CommonHandlers
    {
        private CommonHandlers() { }
        // Common
        public Action<AdizError, string> onResult { get; private set; } = null;

        public class Builder
        {
            private CommonHandlers eventHandlers;

            public Builder()
            {
                this.eventHandlers = new CommonHandlers();
            }

            public Builder OnResult(Action<AdizError, string> args) { eventHandlers.onResult = args; return this; }
            
            public CommonHandlers Build() { return this.eventHandlers; }
        }

    }

}